<?php
include('../db_connect.php'); // Database connection file

// Check if admin is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ../home');
    exit();
}
if(!in_array($_SESSION['role'],[1])){
    msgAlert('You are not Allowed to view this Page!','../home');
}

// Fetch distinct rounds from database
$roundsQuery = "SELECT DISTINCT round_id FROM questions ORDER BY round_id ASC";
$roundsResult = mysqli_query($conn, $roundsQuery);

// Get selected round
$selectedRound = isset($_GET['round']) ? $_GET['round'] : 'all';

// Query to fetch questions based on selected round
if ($selectedRound === 'all') {
    $query = "SELECT * FROM questions ORDER BY round_id, question_number";
} else {
    $query = "SELECT * FROM questions WHERE round_id = '$selectedRound' ORDER BY question_number";
}
$result = mysqli_query($conn, $query);


if (isset($_POST['upload'])) {
    if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0) {
        $fileType = pathinfo($_FILES['excel_file']['name'], PATHINFO_EXTENSION);
        
        if ($fileType != 'csv') {
            die("Error: Please upload a valid CSV file.");
        }
        
        $file = $_FILES['excel_file']['tmp_name'];
        $handle = fopen($file, "r");

        if ($handle !== false) {
            $headerSkipped = false;
            while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                if (!$headerSkipped) {
                    $headerSkipped = true;
                    continue;
                }

                if (!empty($data[0])) { 
                    $round_id = mysqli_real_escape_string($conn, $data[0]);
                    $question_number = getLastQuestionIndex($round_id);
                    $question_text = mysqli_real_escape_string($conn, $data[2]);
                    $code_snippet = mysqli_real_escape_string($conn, $data[3]);
                    // $option_1 = mysqli_real_escape_string($conn, $data[4]);
                    // $option_2 = mysqli_real_escape_string($conn, $data[5]);
                    // $option_3 = mysqli_real_escape_string($conn, $data[6]);
                    // $option_4 = mysqli_real_escape_string($conn, $data[7]);
                    // $correct_option = intval($data[8]);
                    $option_1 = trim(mysqli_real_escape_string($conn, $data[4]));
                    $option_2 = trim(mysqli_real_escape_string($conn, $data[5]));
                    $option_3 = trim(mysqli_real_escape_string($conn, $data[6]));
                    $option_4 = trim(mysqli_real_escape_string($conn, $data[7]));
                    $correct_option = trim(intval($data[8]));

                    $query = "INSERT INTO questions (round_id, question_number, question_text, code_snippet, option_1, option_2, option_3, option_4, correct_option) 
                              VALUES ('$round_id', '$question_number', '$question_text', '$code_snippet', '$option_1', '$option_2', '$option_3', '$option_4', '$correct_option')";
                    
                    mysqli_query($conn, $query);
                }
            }
            fclose($handle);
        }
    }

    header("Location: questions.php?upload=success");
    exit();
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Questions - Quiz Admin</title>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="css/styles.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 30vh;
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
            padding: 5px;
            /* margin-left:  20px; */
        }
        th {
            background: #f9f9f9;
        }

        .upload-container {
            display: flex;
            flex-direction: row;
            background: #fff;
            padding: 20px;
            margin-left: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 350px;
        }

        .upload-container input[type="file"] {
            width: 90%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 10px;
        }

        .filter-container {
            margin-bottom: 20px;
            text-align: left;
        }

        .filter-container select {
            padding: 8px;
            font-size: 16px;
        }

        .btn {
            background: #007bff;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }

        .btn:hover {
            background: #0056b3;
        }

        .link-primary {
            display: inline-block;
            margin-top: 10px;
            text-decoration: none;
            color: #007bff;
            font-weight: bold;
        }

        .link-primary:hover {
            text-decoration: underline;
        }
        /* Highlight correct answers */
        .correct {
            background-color: #28a745;
            color: white;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <nav>
        <ul>
        <li><a href="index.php">Dashboard</a></li>
            <li><a href="questions.php">Manage Questions</a></li>
            <li><a href="exams.php">Manage Exams</a></li>
            <li><a href="users.php">Manage Users</a></li>
            <li><a href="results.php" target="_blank">Results</a></li>
            <li><a href="merge.php" target="_blank">Videos</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </nav>
    <div class="container">
        <h1>Manage Questions</h1>
        
        <div class="body">
                <div class="upload-container">
                    <form action="questions.php" method="POST" enctype="multipart/form-data">
                        <input type="file" name="excel_file" required>
                        <button type="submit" name="upload" class="btn">Upload Excel</button>
                        <span>
                            <a href="downloads/question_format.csv" class="link-primary" download>
                                <i class="fas fa-download"></i> Download Template here
                            </a>
                        </span>
                        

                    </form>
                </div>
                <div class="upload-container">
                        <div class="filter-container">
                            <label for="round-filter">Select Round:</label>
                            <select id="round-filter">
                                <option value="all" <?= ($selectedRound == 'all') ? 'selected' : '' ?>>All</option>
                                <?php while ($row = mysqli_fetch_assoc($roundsResult)) { ?>
                                    <option value="<?= $row['round_id'] ?>" <?= ($selectedRound == $row['round_id']) ? 'selected' : '' ?>>
                                        Round <?= $row['round_id'] ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                </div>
        </div>
        <div id="questions-table">
            <!-- Questions will be loaded here via AJAX -->
        </div>
    </div>

</body>
<script>
         $(document).ready(function() {
            function loadQuestions(round) {
                $.ajax({
                    url: "requests/fetch_questions.php",
                    type: "POST",
                    data: { round: round },
                    success: function(response) {
                        $("#questions-table").html(response);
                    }
                });
            }

            // Load all questions initially
            loadQuestions("all");

            // When the dropdown value changes, load questions dynamically
            $("#round-filter").change(function() {
                var selectedRound = $(this).val();
                loadQuestions(selectedRound);
            });
        });
    </script>
</html>
