<?php
include('../../db_connect.php'); // Make sure this file exists

header("Content-Type: application/json"); // Force JSON response
if (!isset($_POST['user_id'], $_POST['status'])) {
    echo json_encode(["status" => "error", "message" => "Missing parameters"]);
    exit();
}
$user_id = $_POST['user_id'];
$new_status = intval($_POST['status']);

$check_query = "SELECT id FROM users WHERE user_id = ?";
$stmt = $conn->prepare($check_query);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Database error: " . $conn->error]);
    exit();
}
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "User not found"]);
    exit();
}
$update_query = "UPDATE users SET is_active = ? WHERE user_id = ?";
$stmt = $conn->prepare($update_query);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Database error: " . $conn->error]);
    exit();
}
$stmt->bind_param("is", $new_status, $user_id);
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "User status updated"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update status"]);
}

$stmt->close();
$conn->close();
?>
