<?php
include('../db_connect.php'); // Database connection file

// Check if admin is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ../home');
    exit();
}
if(!in_array($_SESSION['role'],[1])){
    msgAlert('You are not Allowed to view this Page!','../home');
}

$query = "SELECT * FROM users t1
          LEFT JOIN rounds t2 ON t2.round_id = t1.round
          LEFT JOIN timer_state t3 ON t3.user_id = t1.user_id
          WHERE t1.role = 2  ORDER BY t1.id DESC";
$result = mysqli_query($conn, $query);
if (isset($_POST['upload'])) {
    if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0) {
        $fileType = pathinfo($_FILES['excel_file']['name'], PATHINFO_EXTENSION);
        
        if ($fileType != 'csv') {
            die("Error: Please upload a valid CSV file.");
        }
        
        $file = $_FILES['excel_file']['tmp_name'];
        $handle = fopen($file, "r");

        if ($handle !== false) {
            $headerSkipped = false;
            while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                if (!$headerSkipped) {
                    $headerSkipped = true;
                    continue;
                }
                $password = generatePassword(6);

                if (!empty($data[0])) { 
                    $user_id = trim(mysqli_real_escape_string($conn, $data[0]));
                    $full_names = processValue(mysqli_real_escape_string($conn, $data[1]));
                    $school_name = processValue(mysqli_real_escape_string($conn, $data[2]));
                    $round = intval($data[3]);
                    $no_of_questions = processValue(mysqli_real_escape_string($conn, $data[4]));
                    $district = processValue(mysqli_real_escape_string($conn, $data[5]));

                    $full_names = $full_names ?? NULL;
                    $school_name = $school_name ?? NULL;

                    if(!getValFromTb('users','user_id',$user_id,'user_id')){
                        $query = "INSERT INTO users (`user_id`, `fullnames`, `role`, `password`, `school_name`, `round`, `no_of_questions`, `district`) 
                              VALUES ('$user_id', '$full_names', 2, '$password', '$school_name', '$round','$no_of_questions','$district')";
                    
                        mysqli_query($conn, $query);
                        TimerSetter($user_id);
                    }
                }
            }
            fclose($handle);
        }
    }

    header("Location: users.php?upload=success");
    exit();
}




?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Questions - Quiz Admin</title>
    <link rel="stylesheet" href="css/styles.css">
    <script src="../js/jquery.js"></script>
    <style>
        .body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 30vh;
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
            padding: 5px;
            /* margin-left:  20px; */
        }
        th {
            background: #f9f9f9;
        }

        .upload-container {
            display: flex;
            flex-direction: row;
            background: #fff;
            padding: 20px;
            margin-left: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 350px;
        }

        .upload-container input[type="file"] {
            width: 90%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 10px;
        }

        .filter-container {
            margin-bottom: 20px;
            text-align: left;
        }

        .filter-container select {
            padding: 8px;
            font-size: 16px;
        }

        .btn {
            background: #007bff;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }

        .btn:hover {
            background: #0056b3;
        }

        .link-primary {
            display: inline-block;
            margin-top: 10px;
            text-decoration: none;
            color: #007bff;
            font-weight: bold;
        }

        .link-primary:hover {
            text-decoration: underline;
        }
        /* Highlight correct answers */
        .correct {
            background-color: #28a745;
            color: white;
            font-weight: bold;
        }
        #searchBox {
    width: 100%;
    max-width: 300px; /* Adjust width */
    padding: 10px;
    font-size: 16px;
    border: 2px solid #007BFF; /* Blue border */
    border-radius: 5px;
    outline: none;
    transition: 0.3s;
}

#searchBox:focus {
    border-color: #0056b3; /* Darker blue on focus */
    box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
}

#searchBox::placeholder {
    color: #888;
    font-style: italic;
}

    </style>
</head>
<body>
    <nav>
        <ul>
            <li><a href="index.php">Dashboard</a></li>
            <li><a href="questions.php">Manage Questions</a></li>
            <li><a href="exams.php">Manage Exams</a></li>
            <li><a href="users.php">Manage Users</a></li>
            <li><a href="results.php" target="_blank">Results</a></li>
            <li><a href="merge.php" target="_blank">Videos</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </nav>
    <div class="container">
        <h1>Manage Users</h1>
        
        <div class="body">
                <div class="upload-container">
                    <form action="users.php" method="POST" enctype="multipart/form-data">
                        <input type="file" name="excel_file" required>
                        <button type="submit" name="upload" class="btn">Upload Excel</button>
                        <span>
                            <a href="downloads/user_format.csv" class="link-primary" download>
                                <i class="fas fa-download"></i> Download Template here
                            </a>
                        </span>
                        

                    </form>
                </div>
                
        </div>
        <input type="text" id="searchBox" placeholder="Search users..." onkeyup="searchTable()">

        <table border="1" width="100%" id="userTable">
    <thead>
        <tr>
            <th>S/N</th>
            <th>Candidate/School's Name</th>
            <th>User ID</th>
            <th>Password</th>
            <!-- <th>Type</th> -->
            <th>Round</th>
            <th>No of Questions</th>
            <th>Time</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
            <tr id="user-<?= $row['user_id'] ?>">
                <td><?= $i; ?></td>
                <td><?= (is_null($row['fullnames']) || empty($row['fullnames']))?htmlspecialchars($row['school_name']):htmlspecialchars($row['fullnames']) ?></td>
                <td><?= htmlspecialchars($row['user_id']) ?></td>
                <td><?= htmlspecialchars($row['password']) ?></td>
                <!-- <td><?= ($row['user_id'] == 1)?'Admin':'Candidate'; ?></td> -->
                <td><?= htmlspecialchars($row['round_name']) ?></td>
                <td><?= htmlspecialchars($row['no_of_questions']) ?></td>
                <td><?= ($row['time_remaining'] == 0)?'Not Set':htmlspecialchars(round($row['time_remaining']/60,2)).' Mins' ?></td>

                <td>
                    <button class="toggle-status" data-id="<?= $row['user_id'] ?>" data-status="<?= $row['is_active'] ?>">
                        <?= $row['is_active'] == 1 ? "Enabled" : "Disabled" ?>
                    </button>
                </td>
                <td>
                    <button class="edit-user" data-id="<?= $row['user_id'] ?>">Edit</button>
                    <button class="delete-user" data-id="<?= $row['user_id'] ?>">Delete</button>
                </td>
            </tr>
        <?php $i++; endwhile; ?>
    </tbody>
</table>
    </div>
<style>
    /* Modal Overlay */
#modal-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 999;
}

/* Modal Box */
#editModal {
    display: none;
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: white;
    padding: 20px;
    width: 400px;
    border-radius: 8px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.3);
    z-index: 1000;
}

/* Modal Content */
.modal-content {
    display: flex;
    flex-direction: column;
}

/* Close Button */
.close-modal {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 24px;
    cursor: pointer;
    color: #555;
}

/* Modal Header */
h2 {
    text-align: center;
    margin-bottom: 15px;
}

/* Form Inputs */
input[type="text"], input[type="email"] {
    width: 90%;
    padding: 10px;
    margin-bottom: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 16px;
}

/* Buttons */
button {
    width: 100%;
    padding: 10px;
    border: none;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
}

/* Update Button */
.update-btn {
    background: #007bff;
    color: white;
    margin-bottom: 10px;
}

/* Cancel Button */
.cancel-btn {
    background: #dc3545;
    color: white;
}

/* Hover Effects */
button:hover {
    opacity: 0.8;
}

</style>
    <!-- Modal -->
    <div id="editModal" style="display:none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; border-radius: 8px; box-shadow: 0px 0px 10px gray;">
        <form id="edit-user-form">
            <input type="text" id="user_id" name="user_id" readonly>

            <label>Full Name:</label>
            <input type="text" id="fullnames" name="fullnames" readonly>

            <label>School Name:</label>
            <input type="text" id="school_name" name="school_name" readonly>

            <label>Password:</label>
            <input type="text" id="password" name="password">

            <label>No of Questions:</label>
            <input type="text" id="no_of_questions" name="no_of_questions">

            <label>Time In Minutes:</label>
            <input type="text" id="time" name="time">

            

            <button type="submit">Update</button>
            <span class="close-modal">&times;</span>
        </form>
    </div>
    <!-- Modal -->
   
</body>

<script>
$(document).ready(function () {

    $(".toggle-status").click(function () {
        
    var userId = $(this).data("id");
    var newStatus = parseInt($(this).data("status")) === 1 ? 0 : 1;
    var button = $(this);
    $.ajax({
        url: "requests/toggle_user.php",
        type: "POST",
        data: { user_id: userId, status: newStatus },
        dataType: "json",
        success: function (response) {
           

            if (response.status === "success") {
                button.text(newStatus === 1 ? "Enabled" : "Disabled");
                button.data("status", newStatus);
                button.toggleClass("btn-success", newStatus === 1)  // Green when Enabled
                button.toggleClass("btn-danger", newStatus !== 1);  // Red when Disabled
            } else {
                alert("Error: " + response.message);
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", xhr.responseText); // Show the full error response
            alert("Something went wrong. Check the console for details.");
        }
    });
});


    // Delete user
    $(".delete-user").click(function () {
        var userId = $(this).data("id");
        if (!confirm("Are you sure you want to delete this user?")) return;

        $.ajax({
            url: "requests/delete_user.php",
            type: "POST",
            data: { user_id: userId },
            success: function (response) {
                //console.log(response)
                if (response.status === "success") {
                    $("#user-" + userId).remove();
                } else {
                    alert("Failed to delete user.");
                }
            }
        });
    });


    $(".edit-user").on("click", function () {
        var userId = $(this).data("id"); // Get user ID from button
        
        // Make AJAX request to fetch user data
        $.ajax({
            url: "requests/get_user.php", // PHP script to fetch user data
            type: "POST",
            data: { user_id: userId },
            dataType: "json",
            success: function (response) {
                console.log(response);
                if (response.success) {
                    // Populate the modal with user data
                    $("#user_id").val(response.data.user_id);
                    $("#fullnames").val(response.data.fullnames);
                    $("#school_name").val(response.data.school_name);
                    // $("#password").val(response.data.password);
                    // $("#no_of_questions").val(response.data.no_of_questions);
                    // $("#time").val((response.data.time_remaining/60).toFixed(2));

                    //keep vals
                    $("#password").val(response.data.password).data("original", response.data.password);
                    $("#no_of_questions").val(response.data.no_of_questions).data("original", response.data.no_of_questions);
                    $("#time").val((response.data.time_remaining/60).toFixed(2)).data("original", response.data.time_remaining);

                    // Show the modal
                    $("#editModal").fadeIn();
                } else {
                    alert("User not found!");
                }
            },
            error: function () {
                alert("Error fetching user data!");
            }
        });
    });

    // Close modal
    $(".close-modal").on("click", function () {
        $("#editModal").fadeOut();
    });

    $("#edit-user-form").on("submit", function (e) {
        e.preventDefault(); // Prevent page reload

        let userId = $("#user_id").val();
        let newPassword = $("#password").val();
        let newQuestions = $("#no_of_questions").val();
        let newTime = $("#time").val()*60;

        // alert(newTime)

        // Fetch existing values from the form (which were pre-filled from the DB)
        let oldPassword = $("#password").data("original");
        let oldQuestions = $("#no_of_questions").data("original");
        let oldTime = $("#time").data("original");

        // Object to store changed values
        let updatedData = { user_id: userId };

        if (newPassword !== oldPassword && newPassword !== "") {
            updatedData.password = newPassword;
        }
        if (newQuestions !== oldQuestions && newQuestions !== "") {
            updatedData.no_of_questions = newQuestions;
        }
        if (newTime !== oldTime && newTime !== "") {
            updatedData.time = newTime;
        }

        // Check if anything changed
        if (Object.keys(updatedData).length > 1) {
            $.ajax({
                url: "requests/update_user.php",
                type: "POST",
                data: updatedData,
                success: function (response) {
                    alert(response); // Show success message
                    $("#editModal").fadeOut(); // Close modal after update
                    window.location.href = 'users.php';
                },
                error: function () {
                    alert("Error updating user!");
                }
            });
        } else {
            alert("No changes detected!");
        }
    });

    


    


});
</script>
<script>
    function searchTable() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchBox");
        filter = input.value.toUpperCase();
        table = document.getElementById("userTable");
        tr = table.getElementsByTagName("tr");

        for (i = 1; i < tr.length; i++) { // Start from 1 to skip the header row
            td = tr[i].getElementsByTagName("td")[1]; // Change index to search by different columns (e.g., Name)
            if (td) {
                txtValue = td.textContent || td.innerText;
                tr[i].style.display = txtValue.toUpperCase().indexOf(filter) > -1 ? "" : "none";
            }
        }
    }
</script>

</html>
