<?php
session_start();
$servername = "localhost";
$username = "root";
$password = "";
$database = "excamdb";

$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


function TimerSetter($user_id){
    global $conn;
    $sql = "SELECT time_remaining FROM timer_state WHERE user_id = ?";
    $stmt_time = $conn->prepare($sql);
    $stmt_time->bind_param("s", $user_id);
    $stmt_time->execute();
    $stmt_time->store_result();

    if ($stmt_time->num_rows <= 0) {
        
        // User does not exist, insert a new record with 1800 seconds (30 min)
        $time_remaining = 1800;
        $insert_sql = "INSERT INTO timer_state (user_id, time_remaining) VALUES (?, ?)";
        $insert_stmt = $conn->prepare($insert_sql);
        $insert_stmt->bind_param("si", $user_id, $time_remaining);
        $insert_stmt->execute();
        $insert_stmt->close();
    }

    $stmt_time->close();
   // $conn->close();
    }

    function checkQandA($user_id,$round,$question){
        global $conn;
        $sql = "SELECT * FROM user_answer WHERE user_id = ? AND round_id = ? AND question_number = ?";
        $stmt_time = $conn->prepare($sql);
        $stmt_time->bind_param("sii", $user_id,$round,$question);
        $stmt_time->execute();
        $stmt_time->store_result();
    
        $exists = $stmt_time->num_rows > 0; // Store result in a variable
        //$stmt_time->close(); // Free statement resources
    
        return $exists;
        }

    function ScoreAvailability($user_id,$round_id){
        global $conn;
        $sql = "SELECT * FROM user_scores WHERE user_id = ? AND round_id = ?";
        $stmt_time = $conn->prepare($sql);
        $stmt_time->bind_param("si", $user_id,$round_id);
        $stmt_time->execute();
        $stmt_time->store_result();
        //$stmt_time->close();    
        if ($stmt_time->num_rows <= 0) {
            return false;
        }return true;
    
    }

    function photoUploaded($user_id){
        global $conn;
        $sql = "SELECT * FROM user_photo WHERE user_id = ?";
        $stmt_time = $conn->prepare($sql);
        $stmt_time->bind_param("s", $user_id);
        $stmt_time->execute();
        $stmt_time->store_result();
        //$stmt_time->close();    
        if ($stmt_time->num_rows <= 0) {
            return false;
        }return true;
    
    }

    function msgAlert($msg,$link='../logged/'){
        $x = '<script type="text/javascript">alert("' . $msg . '")</script>';
        echo $x;          
              if (isset($x)) {          
              echo '<script type="text/javascript"> window.location.href = "' . $link . '"; </script>';         
                }
    }

    function getLastQuestionIndex($round_id){
        global $conn;
        $query = "SELECT MAX(question_number) AS last_index FROM questions WHERE round_id = '$round_id'";
        $result = mysqli_query($conn, $query);
        $row = mysqli_fetch_assoc($result);
        return $row['last_index'] + 1; // Increment for next question

    }

   
    function getValFromTb($table, $column, $value, $returnColumn) {
        global $conn; // Ensure you're using the database connection
        $value = mysqli_real_escape_string($conn, $value);
        $value = is_numeric($value) ? $value : "'$value'";
        $query = "SELECT `$returnColumn` FROM `$table` WHERE `$column` = $value";
        $result = mysqli_query($conn, $query);
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            return $row[$returnColumn];
        } else {
            return null; // Handle cases where no result is found
        }
    }

    function updateRound($user){
        global $conn;
        $currentRound = intval(getValFromTb('users','user_id',$user,'round'));
        $newRound = $currentRound + 1;
        $query = "UPDATE users SET round = '$newRound' WHERE user_id = '$user'";
        $exec = mysqli_query($conn,$query);
    }
    

    function generatePassword($length = 5) {
        $characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
        $password = '';
        $charLength = strlen($characters);
        
        for ($i = 0; $i < $length; $i++) {
            $password .= $characters[rand(0, $charLength - 1)];
        }
        
        return $password;
    }

    function processValue($val) {
        if (empty($val)) {
            return NULL;
        }
        return $val;
    }

    function VerifyLicence() {
        $hashcode = getValFromTb('licence','id',1,'hash_code');
        $hashSalt = getValFromTb('licence','id',1,'hash_salt');
        $input = $hashcode."*".$hashSalt;
        if(empty($input) || is_null($input) || $input == "")return false;
        $parts = explode('*', $input); // Ignore everything after '*'
        $filteredInput = $parts[0];
        $timePath = $parts[1];
        // $baseTimestamp = strtotime("2026-03-27 11:08:03"); 
    
        preg_match_all('/\d/', $filteredInput, $matches); // Extract only single-digit numbers
        $sum = array_sum($matches[0]); // Sum up the extracted numbers
    
        if ($sum === intval(ord('@'))) {
            if (time() <= $timePath) {
                return true;
               // return "The total sum is $sum, and account is active.";
            }else{
                return false;
                //return "The total sum is $sum, But Expired.";
            }
        } else {
            //return "The total sum is $sum, which is not 64.";
            return false;
        }
    }

    
    if(!VerifyLicence()){
        die("License Expired! contact Support");
    }


    function updateAllUserPasswords($mysqli) {
    $charset = 'abcdefghijkmnpqrstuvwxyz123456789';
    $passwordLength = 6;
    $updatedUsers = [];

    // Fetch all users
    $query = "SELECT id, user_id FROM users";
    $result = $mysqli->query($query);

    if (!$result || $result->num_rows === 0) {
        echo "No users found or query failed.";
        return [];
    }

    // Prepare update statement
    $stmt = $mysqli->prepare("UPDATE users SET password = ? WHERE id = ?");

    while ($row = $result->fetch_assoc()) {
        $id = $row['id'];
        $username = $row['user_id'];

        // Generate random password
        $newPassword = '';
        for ($i = 0; $i < $passwordLength; $i++) {
            $newPassword .= $charset[random_int(0, strlen($charset) - 1)];
        }

        // Update password
        $stmt->bind_param("si", $newPassword, $id);
        $stmt->execute();

        // Save in result for return/logging
        $updatedUsers[$username] = $newPassword;
    }

    $stmt->close();
    return $updatedUsers;
}



  //updateAllUserPasswords($conn);
    


?>
