<?php
require "../db_connect.php";
if(!isset($_SESSION['user_id'])){
    header('Location: ./');
}
if(ScoreAvailability($_SESSION['user_id'],$_SESSION['round'])){
    msgAlert('Score Already Available for this User for this round!','../result.php');
}
if(photoUploaded($_SESSION['user_id'])){
    msgAlert('Picture already Captured!','../');
}
if(!in_array($_SESSION['role'],[2])){
    msgAlert('You are not Allowed to view this Page!','../admin');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CBT Exam - Instructions, Photo & Webcam Page!</title>
    <!-- FAVICON -->
    <link rel="shortcut icon" type="image/x-icon" href="../images/favicon.png" />
    <script src="../js/jquery.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            text-align: center;
        }
        li {
            list-style-type: none;
        }
        .container {
            display: flex;
            flex-direction: column;
            max-width: 600px;
            margin: 10px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 10px;
            box-shadow: 10px 4px 10px rgba(0, 115, 135, 0.3);
        }
        .hidden { display: none; }
        video, canvas, #capturedPhoto {
            width: 40%;
            border-radius: 10px;
        }
        #photoCapturePage{
            align-items: center;
        }
        button {
            background: #d9534f;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            float: left;
        }

        button:hover {
            background: #c9302c;
        }
        #proceedToPhoto, #examWebcam{
            width: 50%;
            margin: 0px auto;
        }
        
        ul {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            margin: 0px auto;
            margin-bottom: 10px;
        }
        li {
            padding: 2px;
        }
        .toprow{
            display: flex;
            flex-direction: row-reverse;
            justify-content: space-between;
        }
        #logout{
            display: block;
            color: red;
            align-items: right;
            cursor: pointer;
        }
        /* Blur effect */
.blurred {
    filter: blur(5px);
    pointer-events: none; /* Disable clicks */
}

/* Loading overlay */
#loadingOverlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

/* Loading container */
.loading-container {
    background: white;
    padding: 20px;
    border-radius: 10px;
    text-align: center;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.3);
}

/* Spinner animation */
.spinner {
    width: 40px;
    height: 40px;
    border: 4px solid rgba(0, 0, 0, 0.1);
    border-top: 4px solid #3498db;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 10px auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
} 

/* Loading screen styling */
#loading-div {
            display: none; /* Hidden by default */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            color: white;
            font-size: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
#ppreloader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background-color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            }

.ploader {
            font-size: 1.5rem;
            color: #333;
            font-weight: bold;
            }

    </style>
</head>
<body>
    <div id="ppreloader">
        <div class="ploader">Loading...</div>
    </div>

    <div class="container" id="instructionPage">
        
        <div class="toprow">
            <span id="logout">LogOut</span>
            
        </div>
        <h2>Exam Instructions</h2>
        <p>Please read the following instructions carefully before starting your exam:</p>
        <ul>
            <li>🔹 Ensure you have a stable internet connection.</li>
            <li>🔹 Your webcam must be active throughout the exam.</li>
            <li>🔹 Do not navigate away from the exam window.</li>
            <li>🔹 Any suspicious activity may lead to disqualification.</li>
        </ul>
        <label>
            <input type="checkbox" id="agreeCheckbox"> I have read and agree to the exam rules.
        </label>
        <br>
        <button id="proceedToPhoto" disabled>Proceed to Photo Capture</button>
    </div>
    
    <div class="container hidden" id="photoCapturePage">
        <h3>Photo Capture</h3>
        <p>Please take a clear photo of yourself before proceeding.</p>
        <video id="photoWebcam" autoplay></video>
        <br>
        <button id="capturePhotoBtn">Take Photo</button>
        <br>
        <canvas id="capturedCanvas" class="hidden"></canvas>
        <img id="capturedPhoto" class="hidden" alt="Captured Photo">
        <br>
        <button id="uploadPhotoBtn" class="hidden">Upload Photo</button>
        <p id="uploadStatus"></p>
        <br>
        <button id="proceedToWebcam" class="hidden" disabled>Activate Webcam</button>
    </div>

    <!-- if photo uploaded -->
    <div class="container hidden" id="webcamPage">
        <h2>Webcam Activation</h2>
        <p>Please enable your webcam to continue.</p>
        <video id="examWebcam" autoplay></video>
        <br><br>
        <button id="startExamBtn" disabled>Start Exam</button>
    </div>

    <script>
    window.addEventListener("load", function () {
        const preloader = document.getElementById("ppreloader");
        preloader.style.display = "none";
    });
    </script>

    <script>
        
        document.getElementById("agreeCheckbox").addEventListener("change", function() {
            document.getElementById("proceedToPhoto").disabled = !this.checked;
        });

        document.getElementById("proceedToPhoto").addEventListener("click", function() {
            document.getElementById("ppreloader").style.display = "block";
            document.getElementById("instructionPage").classList.add("hidden");
            document.getElementById("photoCapturePage").classList.remove("hidden");
            setTimeout(function() {
                document.getElementById("ppreloader").style.display = "none";
                //document.body.classList.remove("blurred");
                startPhotoWebcam();
            }, 4000);
            
            //preloader = document.getElementById("ppreloader")
        });

        function startPhotoWebcam() {
            navigator.mediaDevices.getUserMedia({ video: true })
                .then(function(stream) {
                    document.getElementById("photoWebcam").srcObject = stream;
                })
                .catch(function(error) {
                    alert("Webcam access is required to proceed.");
                    //startPhotoWebcam();
                    window.location.href = "gettingstarted.php";  //redirect to instructions page
                });
        }

        document.getElementById("capturePhotoBtn").addEventListener("click", function() {
            let video = document.getElementById("photoWebcam");
            let canvas = document.getElementById("capturedCanvas");
            let img = document.getElementById("capturedPhoto");
            let ctx = canvas.getContext("2d");
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
            img.src = canvas.toDataURL("image/png");
            img.classList.remove("hidden");
            document.getElementById("uploadPhotoBtn").classList.remove("hidden");
        });

        document.getElementById("uploadPhotoBtn").addEventListener("click", function() {
            let canvas = document.getElementById("capturedCanvas");
            let imageData = canvas.toDataURL("image/png").split(',')[1];
            let xhr = new XMLHttpRequest();
            showLoading();
            xhr.open("POST", "uppy.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    document.getElementById("uploadStatus").innerText = xhr.responseText;
                    document.getElementById("proceedToWebcam").disabled = false;
                    document.getElementById("proceedToWebcam").classList.remove("hidden");
                    document.getElementById("uploadPhotoBtn").classList.add("hidden");
                    //document.getElementById("webcamPage").style.display = 'block';
                    
                    hideLoading();
                }
            };
            xhr.send("image=" + encodeURIComponent(imageData));
        });

       
            // Function to show loading overlay
            function showLoading() {
                let overlay = document.createElement("div");
                overlay.id = "loadingOverlay";
                overlay.innerHTML = `
                    <div class="loading-container">
                        <div class="spinner"></div>
                        <p>Uploading image...</p>
                    </div>
                `;
                document.body.appendChild(overlay);
                //document.body.classList.add("blurred"); // Apply blur effect
            }

            // Function to hide loading overlay
            function hideLoading() {
                let overlay = document.getElementById("loadingOverlay");
                if (overlay) {
                    overlay.remove();
                }
                //document.body.classList.remove("blurred");
            }

        document.getElementById("proceedToWebcam").addEventListener("click", function() {
            document.getElementById("photoCapturePage").classList.add("hidden");
            document.getElementById("webcamPage").classList.remove("hidden");
            startExamWebcam();
        });

        document.getElementById("startExamBtn").addEventListener("click", function() {
            window.location.href = "../";
        });
        
        document.getElementById("logout").addEventListener("click", function() {
            let x = confirm('Are you sure to LogOut?');
            if(x){
                    $.ajax({
                        url: 'logout.php',
                        type: 'GET',
                        data: { action: 'logout'},
                        success: function(data){
                            if(data === "success"){
                                    window.location.href = "./";
                            }else{
                                alert('Error!!!');
                            }
                        },
                        error: function(xhr, status, error){
                            console.log(xhr.responseText);
                        }
                    });
            }return
        });
        
        

        function startExamWebcam() {
            navigator.mediaDevices.getUserMedia({ video: true })
                .then(function(stream) {
                    document.getElementById("examWebcam").srcObject = stream;
                    document.getElementById("startExamBtn").disabled = false;
                })
                .catch(function(error) {
                    alert("Webcam access is required to proceed.");
                    
                });
        }
    </script>
</body>
</html>
