<?php
require "../db_connect.php";
$user = $_SESSION['user_id'];
$round = $_SESSION['round'];
$uploadDir = __DIR__ . '/uploads/'.$user.'/photo/round_'.$round.'/';
if (!file_exists($uploadDir) && !mkdir($uploadDir, 0755, true)) {
    die(json_encode(["status" => "error", "message" => "Failed to create upload directory."]));
}

if (isset($_POST['image'])) {
    $imageData = base64_decode($_POST['image']);
    
    if ($imageData === false) {
        die(json_encode(["status" => "error", "message" => "Invalid image data."]));
    }

    $examtaker = $user; // Replace with dynamic user ID if needed

    // Check if user already has an uploaded image
    $stmt = $conn->prepare("SELECT photo_path FROM user_photo WHERE user_id = ?");
    $stmt->bind_param("s", $examtaker);
    $stmt->execute();
    $stmt->bind_result($existingFile);
    $stmt->fetch();
    $stmt->close();

    // Delete the old image if it exists
    if ($existingFile) {
        $oldFilePath = $uploadDir . $existingFile;
        if (file_exists($oldFilePath)) {
            unlink($oldFilePath);
        }
    }

    // Generate new file name and save image
    $fileName = uniqid() . '.png';
    $filePath = $uploadDir . $fileName;

    if (file_put_contents($filePath, $imageData)) {
        // Insert or update the database record
        $stmt = $conn->prepare("
            INSERT INTO user_photo (user_id, photo_path) 
            VALUES (?, ?) 
            ON DUPLICATE KEY UPDATE photo_path = VALUES(photo_path)
        ");
        $stmt->bind_param("ss", $examtaker, $fileName);

        if ($stmt->execute()) {
            //echo json_encode(["status" => "success", "message" => "Photo uploaded and replaced successfully!", "file" => $fileName]);
            echo "Photo uploaded successfully!";
        } else {
            echo json_encode(["status" => "error", "message" => "Database error: " . $conn->error]);
        }

        $stmt->close();
        $conn->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to save the image."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "No image received."]);
}
?>
