<?php
    require 'config.php';
    // if(!isset($_SESSION['user_id'])){
    //     header('Location: home');
    // }
    // if(!isset($_SESSION['check_availability'])){
    //     if(ScoreAvailability($_SESSION['user_id'],$_SESSION['round'])){
    //         $_SESSION['check_availability'] = true;
    //         msgAlert('Score Already Available for this User for this round!','result.php');
    //     }
    // }
    // if(!in_array($_SESSION['role'],[2])){
    //     msgAlert('You are not Allowed to view this Page!','admin');
    // }
    
    
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exam Interface </title>
    <link rel="stylesheet" href="css/styles.css">
    <!-- FAVICON -->
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png" />
    <!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
     <script src="js/jquery.js"></script>
     <style>
        
         /* Loading overlay */
         #loadingOverlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .loading-container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            height: fit-content;

            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.3);
        }
        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 10px auto;
        }

        .spinners{
            width: 40px;
            height: 40px;
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 10px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

     </style>
</head>
<body>
    
    <div class="container" >
        <div id="loading-div">
            <p>No internet connection. Waiting for network...</p>
        </div>

        <header>
            <h1 class="logo"><img src="images/taxclub_header2.png" alt=""></h1>
            <div class="progress-container">
                <div class="progress-bg">
                    <div class="progress-bar" id="progress-bar" style="width: 0%;"></div>
                </div>
                <span class="progress-text" style="font-weight: bolder;">1/<?= $totalQuestions; ?></span>
            </div>
            <!-- <div class="timer">⏳<span id="time"></span></div> -->
            <div class="timer"><span id="time"></span></div>

        </header>
        <div id="loading-spinner" class="spinner"></div>

        <main>
            <h2 id="question-number"></h2>
            <p id="question-text"></p>
            <!-- <pre class="code-block" id="code-block"></pre> -->
            <div class="options" id="options-container"></div>
        </main>
        <footer>
            <button class="prev-btn">← Previous</button>
            <button class="next-btn">Next →</button>
            <button class="submit-btn" hidden>Submit</button>
        </footer>
        <div class="video-section">
            <video id="videoPreview" autoplay playsinline></video>
        </div>
    </div>
   
    
    
</body>
</html>
<script>
let totalQuestions = <?php echo json_encode($totalQuestions); ?>;
let totalDuration = <?php echo json_encode($totalDuration); ?>;
let round_id = <?php echo json_encode($round); ?>;
let userAnswers = JSON.parse(localStorage.getItem("userAnswers")) || []; //to log q and a 
let userAnswer = JSON.parse(localStorage.getItem("userAnswer")) || {}; //to keep log of q and a
let questions = JSON.parse(localStorage.getItem("questions")) || [];
let currentQuestion = getLastAnsweredQuestion();
let mediaRecorder;
let recordedChunks = [];
const chunkInterval = 10000; // Save video chunks every 10 seconds
const snapshotInterval = 3000; // Take pictures every 3 seconds
let videoElement, canvas;
let chunk_counter =  JSON.parse(localStorage.getItem("chunkCounter")) || 0;
let photo_counter = 0;
let timer = 1800; // Default to 30 minutes
let answerSaveTimeout;
let recordingStopped = false; // Flag to prevent further uploads after stopping
let countdownTimeout; // Store timeout reference
let uploadQueue = [];

async function startRecording() {
    try {
        const stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
        // Check if video stream is working
        if (!stream || stream.getVideoTracks().length === 0) {
            throw new Error("No webcam detected");
        }
        document.querySelector(".container").style.display = "block";

        videoElement = document.getElementById("videoPreview");
        videoElement.srcObject = stream;

        //Start Watch for when the webcam stops
        stream.getVideoTracks().forEach(track => {
          track.onended = () => {
            // statusText.textContent = "❌ Webcam was disabled or stopped";
            // alert("❌ Webcam disabled or disconnected");
            window.location.reload();
          };
        });
        //end Watch for when the webcam stops

        const options = {
            mimeType: 'video/webm;codecs=vp8,opus',
            audioBitsPerSecond: 128000, // bump this up to improve quality
            videoBitsPerSecond: 2500000 // adjust as needed
        };

        // mediaRecorder = new MediaRecorder(stream, { mimeType: "video/webm; codecs=vp9",videoBitsPerSecond: 500000 });
        mediaRecorder = new MediaRecorder(stream, options );

        mediaRecorder.ondataavailable = (event) => {
            if (event.data.size > 0) {
                recordedChunks.push(event.data);
                uploadChunk(event.data, chunk_counter);
                
            }
            chunk_counter++;
            localStorage.setItem("chunkCounter", chunk_counter);
        };

        // Start recording and collect data every 30 seconds
        mediaRecorder.start(chunkInterval);
        console.log("Recording started (saving every 30 seconds)");

        // Start taking pictures every 40 seconds
        canvas = document.createElement("canvas");
        setInterval(captureAndUploadSnapshot, snapshotInterval);
        console.log("Snapshot capture started (every 40 seconds)");

    } catch (error) {
        console.error("Webcam access denied or unavailable:", error);
        document.querySelector(".container").style.display = "none"; // Hide the container if no webcam
        alert("Webcam access is required. Reload the page and allow webcam access.");
    }
}


window.addEventListener("load", () => {
    let storedCounter = localStorage.getItem("chunkCounter");
    if (storedCounter) {
        chunk_counter = parseInt(storedCounter);
    } else {
        chunk_counter = 0;
    }
});




    //lastQuestionIndex
    function getLastAnsweredQuestion() {
        let userAnswers = JSON.parse(localStorage.getItem("userAnswer")) || {};
        let answeredQuestions = Object.keys(userAnswers).map(Number); // Convert keys to numbers
        

        if (answeredQuestions.length > 0) {
            return Math.max(...answeredQuestions); // Get the highest question number
        } else {
            return 1; // Default to the first question if none are answered
        }
    }

    // Function to show loading overlay
    function showLoading() {
                let overlay = document.createElement("div");
                overlay.id = "loadingOverlay";
                overlay.innerHTML = `
                    <div class="loading-container">
                        <div class="spinners"></div>
                        <p>Submitting, Please be patient...</p>
                    </div>
                `;
                document.body.appendChild(overlay);
               // document.body.classList.add("blurred"); // Apply blur effect
    }

            // Function to hide loading overlay
            function hideLoading() {
                let overlay = document.getElementById("loadingOverlay");
                if (overlay) {
                    overlay.remove();
                }
                //document.body.classList.remove("blurred");
            }

            

// async function uploadChunk(chunk, chunk_counter) {
//     if (recordingStopped) {
//         console.warn(`Chunk ${chunk_counter} upload skipped because recording stopped.`);
//         return; // Stop uploading chunks if recording is stopped
//     }

//     const formData = new FormData();
//     formData.append("video_chunk", chunk, `chunk_${chunk_counter}.webm`);

//     try {
//         let response = await fetch("requests/upload_chunk.php", { method: "POST", body: formData });
//         let result = await response.json();
//         console.log(`Chunk ${chunk_counter} uploaded:`, result);
//     } catch (error) {
//         console.error(`Upload error for chunk ${chunk_counter}:`, error);
//     }
// }
async function uploadChunk(chunk, chunk_counter) {
    if (recordingStopped) {
        console.warn(`Chunk ${chunk_counter} added to queue.`);
        uploadQueue.push({ chunk, chunk_counter }); // Store chunk in queue
        return;
    }

    const formData = new FormData();
    formData.append("video_chunk", chunk, `chunk_${chunk_counter}.webm`);

    try {
        let response = await fetch("requests/upload_chunk.php", { method: "POST", body: formData });
        let result = await response.json();
        console.log(`Chunk ${chunk_counter} uploaded:`, result);
    } catch (error) {
        console.error(`Upload error for chunk ${chunk_counter}:`, error);
    }
}


function captureAndUploadSnapshot() {
    if (recordingStopped) {
        console.warn(`Snapshots Upload stopped`);
        return; // Stop uploading chunks if recording is stopped
    }
    if (!videoElement || !canvas) return;

    const context = canvas.getContext("2d");
    canvas.width = videoElement.videoWidth;
    canvas.height = videoElement.videoHeight;
    context.drawImage(videoElement, 0, 0, canvas.width, canvas.height);

    canvas.toBlob((blob) => {
       uploadSnapshot(blob); //Uncomment this line
    }, "image/jpeg", 0.9);
}

function uploadSnapshot(blob) {
    const formData = new FormData();
    const timestamp = Date.now();
    formData.append("image", blob, `snapshot_${photo_counter++}.jpg`);

    fetch("requests/upload_snapshot.php", {
        method: "POST",
        body: formData,
    })
    .then(response => response.json())
    .then(data => console.log("Snapshot uploaded:", data))
    .catch(error => console.error("Upload error:", error));
}

// function stopRecording() {
//     recordingStopped = true; // Prevent further uploads
//     if (mediaRecorder && mediaRecorder.state !== "inactive") {
//         mediaRecorder.stop();
//         console.log("Recording stopped.");
//     }

//     // Stop the camera stream
//     if (videoElement && videoElement.srcObject) {
//         const stream = videoElement.srcObject;
//         stream.getTracks().forEach(track => track.stop());
//         videoElement.srcObject = null; // Clear the stream reference
//         console.log("Camera stopped.");
//     }

//     // Prevent further uploads
//     if (recordedChunks.length > 0) {
//         console.log(`Uploading ${recordedChunks.length} remaining chunks...`);

//         // Ensure all uploads complete before proceeding
//         Promise.all(recordedChunks.map((chunk, index) => uploadChunk(chunk, index)))
//             .then(() => {
//                 console.log("All chunks uploaded.");
//                 recordedChunks = []; // Clear chunks after upload
//             })
//             .catch(err => console.error("Error uploading chunks:", err));
//     }

//     // Hide the video section (optional)
//     const videoSection = document.querySelector(".video-section");
//     if (videoSection) {
//         videoSection.style.display = "none";
//     }

//     // Ensure no new chunks are added after stopping
//     recordedChunks = [];
// }

async function stopRecording() {
    recordingStopped = true; // Prevent further uploads

    // Stop MediaRecorder if it's still active
    if (mediaRecorder && mediaRecorder.state !== "inactive") {
        mediaRecorder.stop();
        console.log("Recording stopped.");
    }

    // Stop the camera stream
    if (videoElement && videoElement.srcObject) {
        const stream = videoElement.srcObject;
        stream.getTracks().forEach(track => track.stop());
        videoElement.srcObject = null; // Clear stream reference
        console.log("Camera stopped.");
    }

    // Upload any remaining chunks before clearing them
    if (recordedChunks.length > 0) {
        console.log(`Uploading ${recordedChunks.length} remaining chunks...`);

        try {
            await Promise.all(recordedChunks.map((chunk, index) => uploadChunk(chunk, index))); // Parallel upload
            console.log("All chunks uploaded successfully.");
        } catch (error) {
            console.error("Error uploading chunks:", error);
        }
    }

    // Clear recorded chunks AFTER uploading to avoid loss
    recordedChunks = [];

    // Hide the video section (optional)
    const videoSection = document.querySelector(".video-section");
    if (videoSection) {
        videoSection.style.display = "none";
    }
}



$(".submit-btn").click(() => {
    let selectedOption = parseInt($("input[name='answer']:checked").val()) || 0;
    
    saveAnswerNoDuplicate(currentQuestion, selectedOption);

    $(".submit-btn, .prev-btn").prop("disabled", true).hide();

    let userAnswers = JSON.parse(localStorage.getItem('userAnswers')) || [];

    if (userAnswers.length > 0) {
        stopRecording();
        clearTimeout(countdownTimeout);

        $.ajax({
            url: "requests/save_final.php",
            type: "POST",
            data: { quizData: userAnswers },
            beforeSend: showLoading,
            success: () => {
                localStorage.clear();
                window.location.href = "result.php";
            },
            error: (xhr, status, error) => console.error("Error:", error),
            complete: hideLoading
        });
    } else {
        console.log("No data found in Storage.");
    }
});


// Hide the container by default
document.addEventListener("DOMContentLoaded", () => {
    document.querySelector(".container").style.display = "none";

    navigator.mediaDevices.getUserMedia({ video: true, audio: true })
        .then(() => {
            document.querySelector(".container").style.display = "block"; // Show only if webcam is enabled
            startRecording();
        })
        .catch(() => {
            console.error("Webcam access denied.");
            document.querySelector(".container").style.display = "none"; // Hide container if webcam is blocked
            alert("Webcam access is required. Reload the page and allow webcam access.");
        });
});

function saveAnswerNoDuplicate(questionNumber, selectedAnswer) {
        // Check if the question already exists in the array
        let index = userAnswers.findIndex(ans => ans.questionNumber === questionNumber);
    
        if (index !== -1) {
            // If found, update the existing answer
            userAnswers[index].answer = selectedAnswer;
        } else {
            // If not found, add a new answer
            userAnswers.push({ questionNumber, answer: selectedAnswer });
        }
    
        // Save back to localStorage
        localStorage.setItem("userAnswers", JSON.stringify(userAnswers));

        userAnswer[questionNumber] = selectedAnswer; // Save the answer
        localStorage.setItem("userAnswer", JSON.stringify(userAnswer)); // Store in localStorage
        sessionLogger(questionNumber,selectedAnswer);
}

function sessionLogger(questionNumber, selectedOption) {

    $.ajax({
        url: "requests/fetch_data.php",
        type: "POST",
        data: { questionNumber: questionNumber, answer: selectedOption },
        dataType: "json",
        success: function (response) {
            console.log("AJAX Success: Session Variable appended");
        },
        error: function (xhr, status, error) {
           console.log("AJAX Error:", xhr.responseText, status, error);
        }
    });
}


function checkNetworkStatus() {
    const loadingDiv = document.getElementById("loading-div");

    if (!navigator.onLine) {
        loadingDiv.style.display = "flex"; // Show loading screen
        
    } else {
        loadingDiv.style.display = "none"; // Hide when network is back
        // window.location.reload();
    }
}

// Check status when the page loads
window.addEventListener("load", checkNetworkStatus);

// Detect when network goes offline
window.addEventListener("offline", () => {
    document.getElementById("loading-div").style.display = "flex";
});

// Detect when network comes back online
window.addEventListener("online", () => {
    document.getElementById("loading-div").style.display = "none";
});



//full screen
document.addEventListener("DOMContentLoaded", () => {
    const elem = document.documentElement; // Selects the entire page

    // Function to request fullscreen
    function goFullScreen() {
        if (elem.requestFullscreen) {
            elem.requestFullscreen();
        } else if (elem.mozRequestFullScreen) { // Firefox
            elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) { // Chrome, Safari, Opera
            elem.webkitRequestFullscreen();
        } else if (elem.msRequestFullscreen) { // IE/Edge
            elem.msRequestFullscreen();
        }
    }

    // Ask the user to click to enable fullscreen
    document.addEventListener("click", goFullScreen, { once: true });
});

// function mergeVideos(){
//     $.ajax({
//                     url: "requests/merge_chunks2.php",
//                     type: "POST",
//                     dataType: "json",
//                     success: function (response) {
//                         if (response.status === "success") {
//                             alert('merged');
//                         } else {
//                             alert("Error Merging Videos");
//                         }
//                     },
//                     error: function () {
//                         $("#status").html("❌ Error executing the merge script.");
//                     }
//                 });
// }
</script>
<script src="js/scripts.js"></script>