
$(document).ready(function () {
    
    //fecth question if q.length= 0 else, load localstorage
    if (questions.length === 0) {
        fetchQuestion();
    } else {
        displayQuestion(currentQuestion);
    }
    
    if(currentQuestion > 1){
        updateProgressBar()
        $(".prev-btn").show(); //show prev button
    }else{
        $(".prev-btn").hide(); //hide prev button
    }

    function fetchTimer() {
        $.get("requests/fetch_timer.php", function (data) {
            if (data.time_remaining) {
                timer = parseInt(data.time_remaining);
                //totalDuration = 1800;
                
                updateTimer();
            }
        }, "json");
    }

    function saveTimer() {
        $.post("requests/save_timer.php", { time_remaining: timer });
    }

    function updateTimer() {
        let minutes = Math.floor(timer / 60);
        let seconds = timer % 60;
        $("#time").text(` ${minutes}:${seconds < 10 ? '0' : ''}${seconds}`);

        let progressPercentage = ((totalDuration - timer) / totalDuration) * 100;
        $("#progress-bar").css("width", progressPercentage + "%");

        if (timer <= 500) {
            $("#progress-bar").css("background-color", "red");
        }
            if (timer > 0) {
                timer--;
                saveTimer();
                setTimeout(updateTimer, 1000); //every 5 seconds
            }else {
                //insert answers if not completed
                submitAnswers();
                // localStorage.clear(); // Clears all localStorage data
                // alert("Time is up! Submitting your exam...");
                // window.location.href = "result.php";
            }
        
    }


    function fetchQuestion() {
        $.ajax({
            url: "requests/fetch_questions.php",
            type: "GET",
            data: { question_number: currentQuestion }, 
            dataType: "json",
            beforeSend: function () {
                $("#loading-spinner").show(); 
                $("body").addClass("blurred");
                $("button").prop("disabled", true);
            },
            success: function (data) {
                if (data.error) {
                    $("#question-text").text("Error: " + data.error);
                } else {
                    // localStorage.clear();
                    // if (localStorage.length === 0) {
                    //     localStorage.setItem("questions", JSON.stringify(data.questions));
                    //     questions = data.questions;
                    //     displayQuestion(currentQuestion);
                    // }
                    localStorage.setItem("questions", JSON.stringify(data.questions));
                    questions = data.questions;
                    displayQuestion(currentQuestion);
                }
            },
            error: function () {
                $("#question-text").text("Error fetching question. Check database connection.");
            },
            complete: function () {
                $("#loading-spinner").hide(); 
                $("body").removeClass("blurred");
                $("button").prop("disabled", false);
            }
        });
    }

    // function displayQuestion(questionIndex) {
    //     if (questionIndex < 0 || questionIndex >= questions.length) return;

    //     let questionData = questions[questionIndex - 1];
    //     $("#question-number").text("Question " + (questionIndex));
    //     $("#question-text").text(questionData.question_text);

    //     let savedAnswer = userAnswer[questionIndex] || "";
    //     let optionsHtml = "";
    //     questionData.options.forEach((option, index) => {
    //         let optionValue = index + 1;
    //         let checked = savedAnswer == optionValue ? "checked" : "";
    //         optionsHtml += `<label><input type='radio' name='answer' value='${optionValue}' ${checked} onclick='saveAnswerNoDuplicate(${questionIndex}, ${optionValue})'> ${option}</label>`;
    //     });
    //     $("#options-container").html(optionsHtml);
    // }

    function displayQuestion(questionIndex) {
        // Ensure the index is within the valid range
        if (questionIndex < 0 || questionIndex >= questions.length) return;
    
        let questionData = questions[questionIndex]; // Use correct index
        $("#question-number").text("Question " + (questionIndex)); // Fix numbering
        $("#question-text").text(questionData.question_text);
    
        let savedAnswer = userAnswer[questionIndex] || "";
        let optionsHtml = "";
    
        questionData.options.forEach((option, index) => {
            let optionValue = index + 1;
            let checked = savedAnswer == optionValue ? "checked" : "";
            
            optionsHtml += `
                <label>
                    <input type='radio' name='answer' value='${optionValue}' ${checked} 
                        onclick='saveAnswerNoDuplicate(${questionIndex}, ${optionValue})'>
                    ${option}
                </label>`;
        });
    
        $("#options-container").html(optionsHtml);
    
        // Check if it's the last question
        if (questionIndex === questions.length - 1) {
            $("#next-btn").hide();  // Hide "Next" button
            $("#submit-btn").show(); // Show "Submit" button
        } else {
            $("#next-btn").show();   // Show "Next" button
            $("#submit-btn").hide(); // Hide "Submit" button
        }
    }


    function updateProgressBar() {
        //$(".progress-text").text(currentQuestion + "/" + totalQuestions);
        $(".progress-text").text(`Question ${currentQuestion} of ${totalQuestions}`);
    }

    //check if question and answer exists in db
    function checkAnswer(question_number, userAnswer) {
        $.ajax({
            url: "requests/check_answer.php", // Backend PHP file
            type: "POST",
            data: {
                question_number: question_number,
                userAnswer: userAnswer
            },
            success: function (response) {
                if (response.exists) {
                    // console.log("Answer exists in the database.");
                    return response.exists;
                } else {
                    // console.log("Answer does not exist.");
                    return !response.exists;
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }

    $(".next-btn").click(function () {
        let selectedOption = parseInt($("input[name='answer']:checked").val());
        if (!selectedOption) { 
            selectedOption = 0;
            // alert("Please select an answer before proceeding.");
            //return;
        }
        $("#loading-spinner").show(); // Show the loading spinner

        setTimeout(function() {
            $("#loading-spinner").hide(); // Hide the spinner after 2 seconds
        }, 300);
        $("#question-text, #options-container").fadeOut(300, function () {
            // Show new question
            $("#question-text, #options-container").fadeIn(300);
        });

        // $(".prev-btn").show();
        if(currentQuestion >= 0){
            $(".prev-btn").show();
        }
        if(currentQuestion >= totalQuestions - 1){
            // $(".next-btn").text("Submit").css("background-color", "green")
            //submit-btn
            $(".next-btn").hide();
            $(".submit-btn").show();

        }else{
            $(".next-btn").text("Next →").css("background-color", "#c9302c")
            $(".next-btn").show();
        }

        // saveAnswerNoDuplicate(currentQuestion,selectedOption);
        saveAnswerNoDuplicate(currentQuestion,selectedOption);
        

        if (currentQuestion < totalQuestions) {
            
            currentQuestion++;
            // fetchQuestion();
            displayQuestion(currentQuestion);
            updateProgressBar();
        } else {
            alert("Exam Completed!");
            localStorage.clear(); // Clears all localStorage data
            window.location.href = "result.php"; // Redirect to result page
        }
    });


    if(currentQuestion == totalQuestions){
        $(".next-btn").hide();
        $(".submit-btn").show();
    }


    $(".prev-btn").click(function () {
        $("#loading-spinner").show(); // Show the loading spinner
        setTimeout(function() {
            $("#loading-spinner").hide(); // Hide the spinner after 2 seconds
        }, 300);
        $("#question-text, #options-container").animate({ left: "-100px", opacity: 0 }, 300, function () {
            $(this).css({ left: "100px", opacity: 0 }).animate({ left: "0px", opacity: 1 }, 300);
        });
        if(currentQuestion <= 2){
            $(".prev-btn").hide();
            $(".next-btn").show();
        }
        // else{
            
        // }
        if(currentQuestion <= totalQuestions){
            $(".next-btn").show();
            $(".submit-btn").hide();
            $(".next-btn").text("Next →").css("background-color", "#c9302c")
        }
        //alert(currentQuestion)
        if (currentQuestion > 1) {
            currentQuestion--;
            // fetchQuestion();
            displayQuestion(currentQuestion);
            updateProgressBar();
        }
    });

   

    setInterval(() => {
        fetch("requests/check_password.php")
            .then(response => response.json())
            .then(data => {
                if (data.status === "logout") {
                    alert("Your session has expired. Please request a new credentials and log in again.");
                    window.location.href = "home";
                }
            })
            .catch(error => console.error("Error checking password:", error));
    }, 2000); // Runs every 2 secs (120000 ms)


    function submitAnswers() {
        $.ajax({
        url: "requests/s_a_timeout.php",
        type: "POST",
        data: { totalQuestion: totalQuestions },
        success: function (response) {
            localStorage.clear(); // Clears all localStorage data
            alert("Time is up! Submitting your exam...");
            window.location.href = "result.php";
        },
        error: function () {
            alert("Error saving answers. Please contact support.");
        }
        });
    }

    fetchTimer();
    displayQuestion(currentQuestion);
    // fetchTimer().then(() => {
    //     if (!currentQuestion || currentQuestion < 1) {
    //         currentQuestion = 1; // Set default if undefined
    //     }
    //     displayQuestion(currentQuestion);
    // }).catch(error => {
    //     console.error("Error fetching timer:", error);
    //     displayQuestion(currentQuestion || 1); // Ensure at least Question 1 is shown
    // });
});

