
$(document).ready(function () {
    //toggleAnswerPreview();
    //fecth question if q.length= 0 else, load localstorage
    if (questions.length === 0) {
        fetchQuestion();
    } else {
        displayQuestion(currentQuestion);
    }
    
    if(currentQuestion > 1){
        updateProgressBar()
        $(".prev-btn").show(); //show prev button
    }else{
        $(".prev-btn").hide(); //hide prev button
    }

    function fetchTimer() {
        $.get("requests/fetch_timer.php", function (data) {
            if (data.time_remaining) {
                timer = parseInt(data.time_remaining);
                //totalDuration = 1800;
                
                updateTimer();
            }
        }, "json");
    }

    function saveTimer() {
        $.post("requests/save_timer.php", { time_remaining: timer });
    }

    function updateTimer() {
        let minutes = Math.floor(timer / 60);
        let seconds = timer % 60;
        $("#time").text(` ${minutes}:${seconds < 10 ? '0' : ''}${seconds}`);

        let progressPercentage = ((totalDuration - timer) / totalDuration) * 100;
        $("#progress-bar").css("width", progressPercentage + "%");

        if (timer <= 500) {
            $("#progress-bar").css("background-color", "red");
        }
            if (timer > 0) {
                timer--;
                saveTimer();
                countdownTimeout = setTimeout(updateTimer, 1000); //every 5 seconds
            }else {
                //insert answers if not completed
                submitAnswers();
                // localStorage.clear(); // Clears all localStorage data
                // alert("Time is up! Submitting your exam...");
                // window.location.href = "result.php";
            }
        
    }


    function fetchQuestion() {
        $.ajax({
            url: "requests/fetch_questions.php",
            type: "GET",
            data: { question_number: currentQuestion }, 
            dataType: "json",
            beforeSend: function () {
                $("#loading-spinner").show(); 
                $("body").addClass("blurred");
                $("button").prop("disabled", true);
            },
            success: function (data) {
                if (data.error) {
                    $("#question-text").text("Error: " + data.error);
                } else {
                    localStorage.setItem("questions", JSON.stringify(data.questions));
                    questions = data.questions;
                    displayQuestion(currentQuestion);
                }
            },
            error: function () {
                $("#question-text").text("Error fetching question. Check database connection.");
            },
            complete: function () {
                $("#loading-spinner").hide(); 
                $("body").removeClass("blurred");
                $("button").prop("disabled", false);
            }
        });
    }

    // function displayQuestion(questionIndex) {
    //     if (questionIndex < 0 || questionIndex > questions.length) return;

    //     let questionData = questions[questionIndex - 1];
    //     $("#question-number").text("Question " + (questionIndex));
    //     $("#question-text").text(questionData.question_text);

    //     let savedAnswer = userAnswer[questionIndex] || "";
        
    //     let optionsHtml = "";
    //     questionData.options.forEach((option, index) => {
    //         let optionValue = index + 1;
    //         let checked = savedAnswer == optionValue ? "checked" : "";
    //         optionsHtml += `<label><input type='radio' name='answer' value='${optionValue}' ${checked} onclick='saveAnswerNoDuplicate(${questionIndex}, ${optionValue})'> ${option}</label>`;
    //     });
        
    //     $("#options-container").html(optionsHtml);
    //     // handleAnswer(questionIndex);
    // }
    function displayQuestion(questionIndex) {
            if (questionIndex < 1 || questionIndex > questions.length) return;

            let questionData = questions[questionIndex - 1];
            $("#question-number").text("Question " + (questionIndex));
            $("#question-text").text(questionData.question_text);

            // Get saved answer for this question
            let savedAnswer = userAnswer[questionIndex] || "";

            let optionsHtml = "";
            questionData.options.forEach((option, index) => {
                let optionValue = index + 1;
                let checked = savedAnswer == optionValue ? "checked" : "";
                optionsHtml += `
                    <label>
                        <input type='radio' name='answer' value='${optionValue}' ${checked} 
                        onclick='saveAnswerNoDuplicate(${questionIndex}, ${optionValue});'>
                        ${option}
                    </label>`;
            });
            $("#options-container").html(optionsHtml);

            // Show or hide Next button based on saved answer
            //checkNextButton(questionIndex);
    }

    // function checkNextButton(questionIndex) {
    //     let savedAnswer = userAnswer[questionIndex] || "";
    //     if (savedAnswer) {
    //         $("#next-btn").prop("disabled", false).removeClass("disabled-btn");
    //     } else {
    //         $("#next-btn").prop("disabled", true).addClass("disabled-btn");
    //     }
    // }




    function updateProgressBar() {
        //$(".progress-text").text(currentQuestion + "/" + totalQuestions);
        $(".progress-text").text(`Question ${currentQuestion} of ${totalQuestions}`);
    }

    //check if question and answer exists in db
    function checkAnswer(question_number, userAnswer) {
        $.ajax({
            url: "requests/check_answer.php", // Backend PHP file
            type: "POST",
            data: {
                question_number: question_number,
                userAnswer: userAnswer
            },
            success: function (response) {
                if (response.exists) {
                    // console.log("Answer exists in the database.");
                    return response.exists;
                } else {
                    // console.log("Answer does not exist.");
                    return !response.exists;
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX Error:", error);
            }
        });
    }
    

    $(".next-btn").click(function () {
        let selectedOption = parseInt($("input[name='answer']:checked").val());
        if (!selectedOption) { 
            selectedOption = 0;
        }
        

        $("#loading-spinner").show(); // Show the loading spinner

        setTimeout(function() {
            if(currentQuestion < totalQuestions - 1){
                // always hide the next Button until an answer is selected
                $(".next-btn").hide();
            }
            $("#loading-spinner").hide(); // Hide the spinner after 2 seconds
        }, 300);
        $("#question-text, #options-container").fadeOut(300, function () {
            // Show new question
            $("#question-text, #options-container").fadeIn(300);
        });

        // $(".prev-btn").show();
        if(currentQuestion >= 0){
            $(".prev-btn").show();
        }
        if(currentQuestion >= totalQuestions - 1){
            // $(".next-btn").text("Submit").css("background-color", "green")
            //submit-btn
            $(".next-btn").hide();
            $(".submit-btn").show();

        }else{
            $(".next-btn").text("Next →").css("background-color", "#c9302c")
            $(".next-btn").show();
        }

        // saveAnswerNoDuplicate(currentQuestion,selectedOption);
        saveAnswerNoDuplicate(currentQuestion,selectedOption);
        

        if (currentQuestion < totalQuestions) {
            currentQuestion++;
            // fetchQuestion();
            displayQuestion(currentQuestion);
            updateProgressBar();
            //checkNextButton(currentQuestion);
        }
        else {
            alert("Exam Completed!");
            localStorage.clear(); // Clears all localStorage data
            window.location.href = "result.php"; // Redirect to result page
        }
    });

    $(".next-btn").show();
    if(currentQuestion == totalQuestions){
        displayQuestion(currentQuestion);
        $(".next-btn").hide();
        $(".submit-btn").show();
    }

    

    document.getElementById("answerPreview").addEventListener("click", (e) => {
        const clickedCard = e.target.closest(".answer-card");
        if (clickedCard) {
            const questionDiv = clickedCard.querySelector(".question-number");
            const number = questionDiv.textContent.slice(1).trim();
            // console.log("Clicked Card for Question #", number);

            if (number) {
                currentQuestion = parseInt(number);
                if(currentQuestion >= totalQuestions){
                    $(".next-btn").hide();
                    $(".submit-btn").show();
                }else{
                    $(".next-btn").show();
                    $(".submit-btn").hide();
                }
                displayQuestion(currentQuestion);
                updateProgressBar();
                //checkNextButton(currentQuestion);
                
            }
        }
    });



    $(".prev-btn").click(function () {
        $("#loading-spinner").show(); // Show the loading spinner
        setTimeout(function() {
            $("#loading-spinner").hide(); // Hide the spinner after 2 seconds
        }, 300);
        $("#question-text, #options-container").animate({ left: "-100px", opacity: 0 }, 300, function () {
            $(this).css({ left: "100px", opacity: 0 }).animate({ left: "0px", opacity: 1 }, 300);
        });
        if(currentQuestion <= 2){
            $(".prev-btn").hide();
            $(".next-btn").show();
        }
        if(currentQuestion <= totalQuestions){
            $(".next-btn").show();
            $(".submit-btn").hide();
            $(".next-btn").text("Next →").css("background-color", "#c9302c")
        }
        //alert(currentQuestion)
        if (currentQuestion > 1) {
            currentQuestion--;
            // fetchQuestion();
            displayQuestion(currentQuestion);
            updateProgressBar();
           // checkNextButton(currentQuestion);
        }
    });

   

    setInterval(() => {
        fetch("requests/check_password.php")
            .then(response => response.json())
            .then(data => {
                if (data.status === "logout") {
                    alert("Your session has expired. Please request a new credentials and log in again.");
                    window.location.href = "home";
                }
            })
            .catch(error => console.error("Error checking password:", error));
    }, 2000); // Runs every 2 secs (120000 ms)


    function submitAnswers() {
        $.ajax({
        url: "requests/s_a_timeout.php", //submit
        type: "POST",
        data: { totalQuestion: totalQuestions },
        success: function (response) {
            localStorage.clear(); // Clears all localStorage data
            alert("Time is up! Submitting your exam...");
            window.location.href = "result.php";
        },
        error: function () {
            alert("Error saving answers. Please contact support.");
        }
        });
    }

    fetchTimer();
    displayQuestion(currentQuestion);
    //checkNextButton(currentQuestion);
});

