<?php
require "db_connect.php";
$round_id = $_SESSION['round'];
$user_id = $_SESSION['user_id'];
$chunksDir = "home/uploads/".$user_id."/video/round_".$round_id."/"; // Adjust to your directory
$outputFile = "home/uploads/".$user_id."/video/round_".$round_id."/".$round_id.".webm";
$listFile = $chunksDir . "chunks_list.txt";

if (!file_exists($chunksDir)) {
    mkdir($chunksDir, 0777, true);
}

// Get all .webm chunks and sort them
$files = glob($chunksDir . "*.webm");
natsort($files);

// Ensure there are chunks
if (count($files) === 0) {
    die("No video chunks found!");
}

// Create the concatenation string
$concatString = "";
$lastIndex = count($files) - 1;

foreach ($files as $index => $file) {
    
    if ($index !== $lastIndex) {
        $concatString .= "|"; // Add | except for the last file
    }
    $concatString .= $file; // Full path required
}

// Build and execute ffmpeg command
$ffmpegCommand = "ffmpeg -i \"concat:$concatString\" -c copy \"$outputFile\" 2>&1";
exec($ffmpegCommand, $output, $returnVar);

// Output result
if ($returnVar === 0) {
    echo "Merging successful! Video saved as: $outputFile";
} else {
    echo "Error merging videos:\n";
    print_r($output);
}
?>
