<?php
require "../db_connect.php";
header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || !isset($_SESSION['round'])) {
    exit("Unauthorized access");
}

$user = $_SESSION['user_id'];
$round = intval($_SESSION['round']); // Ensure round_id is an integer

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn->begin_transaction(); // Start transaction

    try {
        $stmt = $conn->prepare("INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?)");
        if (!$stmt) {
            throw new Exception("SQL Error: " . $conn->error);
        }

        // Merge both `$_POST['quizData']` and `$_SESSION['quiz_answers']` handling into one
        $quizData = isset($_POST['quizData']) && is_array($_POST['quizData']) ? $_POST['quizData'] : [];
        if (isset($_SESSION['quiz_answers']) && is_array($_SESSION['quiz_answers'])) {
            // $quizData = array_merge($quizData, $_SESSION['quiz_answers']);
            foreach ($quizData as $item) {
                $questionNumber = intval($item['qIndex']); // Handle both array formats
                $answer = intval($item['answer']);
    
                if (!checkQandA($user, $round, $questionNumber)) {
                    $stmt->bind_param("siii", $user, $round, $questionNumber, $answer);
                    if (!$stmt->execute()) {
                        throw new Exception("Execution failed: " . $stmt->error);
                    }
                }
            }
            unset($_SESSION['quiz_answers']); // Prevent duplicate submissions
        }
        echo json_encode(["status" => "error", "message" => 'logged']);

        

        $stmt->close();
        $conn->commit(); // Commit transaction if all queries succeed

    } catch (Exception $e) {
        $conn->rollback(); // Rollback on failure
        error_log("Transaction Failed: " . $e->getMessage());
        exit("Error: Data submission failed.");
    }
}
?>
