<?php
include '../db_connect.php';

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["totalQuestion"])) {
    
    $user = $_SESSION['user_id'];
    $round = $_SESSION['round'];
    $totalQuestions = (isset($_POST["totalQuestion"]))?$_POST["totalQuestion"]: 50;
    $selected_option = 0;

    // Securely fetch the latest user answer for the given round
    $sql = "SELECT * FROM user_answer WHERE user_id = ? AND round_id = ? ORDER BY id DESC LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $user, $round);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $last_number =  $row['question_number'];

        for ($i= $last_number + 1; $i < $totalQuestions+1; $i++) { 
            $insertQuery = "INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($insertQuery);
            $stmt->bind_param("siii", $user, $round, $i, $selected_option);
            $stmt->execute();
        }

    } else {
        // No answer found
        //echo json_encode(["status" => "error", "message" => "No answer found"]);
        for ($i= 1; $i < $totalQuestions+1; $i++) { 
            $insertQuery = "INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($insertQuery);
            $stmt->bind_param("siii", $user, $round, $i, $selected_option);
            $stmt->execute();
        }
    }
    $stmt->close();



}



?>
