<?php
require "../db_connect.php";

if (!isset($_SESSION['user_id']) || !isset($_SESSION['round'])) {
    exit("Unauthorized access");
}

$user = $_SESSION['user_id'];  
$round = intval($_SESSION['round']);   // Ensure round_id is an integer

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['quizData']) && is_array($_POST['quizData'])) {
        
        $quizData = $_POST['quizData'];
        $conn->begin_transaction(); // Start transaction

        try {
            $stmt = $conn->prepare("INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?)");

            if (!$stmt) {
                throw new Exception("SQL Error: " . $conn->error);
            }

            foreach ($quizData as $item) {
                $questionNumber = intval($item['questionNumber']);
                $answer = intval($item['answer']);

               // if (!checkQandA($user, $round, $questionNumber)) {
                    $stmt->bind_param("siii", $user, $round, $questionNumber, $answer);
                    if (!$stmt->execute()) {
                        throw new Exception("Execution failed: " . $stmt->error);
                    }
               // }
            }

            $stmt->close();
            $conn->commit(); // Commit transaction if all queries succeed

        } catch (Exception $e) {
            $conn->rollback(); // Rollback on failure
            error_log("Transaction Failed: " . $e->getMessage());
            exit("Error: Data submission failed.");
        }
    }
    if (isset($_SESSION['quiz_answers']) && is_array($_SESSION['quiz_answers'])) {
        $quizData = $_SESSION['quiz_answers'];
        $conn->begin_transaction(); // Start transaction
        try {
            $stmt = $conn->prepare("INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?)");

            if (!$stmt) {
                throw new Exception("SQL Error: " . $conn->error);
            }

            foreach ($quizData as $item) {
                $questionNumber = intval($item['question_number']);
                $answer = intval($item['answer']);

                if (!checkQandA($user, $round, $questionNumber)) {
                    $stmt->bind_param("siii", $user, $round, $questionNumber, $answer);
                    if (!$stmt->execute()) {
                        throw new Exception("Execution failed: " . $stmt->error);
                    }
                }
            }
            unset($_SESSION['quiz_answers']); // Reset session questions after submission
            $stmt->close();
            $conn->commit(); // Commit transaction if all queries succeed

        } catch (Exception $e) {
            $conn->rollback(); // Rollback on failure
            error_log("Transaction Failed: " . $e->getMessage());
            exit("Error: Data submission failed.");
        }
    }

    
}
?>
