<?php
session_start();
require "../db_connect.php";

if (!isset($_SESSION['user_id']) || !isset($_SESSION['round'])) {
    exit(json_encode(["status" => "error", "message" => "Unauthorized access"]));
}

$user = $_SESSION['user_id'];
$round = intval($_SESSION['round']);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $quizData = [];

    // Prioritize POST data, fallback to session if empty
    if (isset($_POST['quizData']) && is_array($_POST['quizData'])) {
        $quizData = $_POST['quizData'];
    } elseif (isset($_SESSION['quiz_answers']) && is_array($_SESSION['quiz_answers'])) {
        $quizData = [];
        foreach ($_SESSION['quiz_answers'] as $questionNumber => $answer) {
            $quizData[] = ["questionNumber" => $questionNumber, "answer" => $answer];
        }
        
    }

    if (!empty($quizData)) {
        $conn->begin_transaction(); // Start transaction
        try {
            $stmt = $conn->prepare("INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?)");
            if (!$stmt) {
                throw new Exception("SQL Error: " . $conn->error);
            }

            foreach ($quizData as $item) {
                if (!isset($item['questionNumber']) || !isset($item['answer']) || !is_numeric($item['questionNumber']) || !is_numeric($item['answer'])) {
                    throw new Exception("Invalid data: " . json_encode($item));
                }

                $questionNumber = intval($item['questionNumber']);
                $answer = intval($item['answer']);

                // Optional check to prevent duplicate submissions
                if (!checkQandA($user, $round, $questionNumber)) {
                    $stmt->bind_param("siii", $user, $round, $questionNumber, $answer);
                    if (!$stmt->execute()) {
                        throw new Exception("Execution failed: " . $stmt->error);
                    }
                }
            }
            unset($_SESSION['quiz_answers']); // Clear session after processing
            $stmt->close();
            $conn->commit(); // Commit transaction

            echo json_encode(["status" => "success", "message" => "Answers saved successfully."]);
        } catch (Exception $e) {
            $conn->rollback(); // Rollback on failure
            error_log("Transaction Failed: " . $e->getMessage());
            echo json_encode(["status" => "error", "message" => "Data submission failed."]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "No valid quiz data found."]);
    }
}
?>
