<?php
require 'config.php';
if(!isset($_SESSION['user_id'])){
    header('Location: home');
}
if(!in_array($_SESSION['role'],[2])){
    msgAlert('You are not Allowed to view this Page!','../admin');
}
// if(!ScoreAvailability($_SESSION['user_id'],$_SESSION['round'])){
//     msgAlert('No Score Available for this round Yet','./');
// }
$round_id = $_SESSION['round'];
$user_id = $_SESSION['user_id'];
$school_name = $_SESSION['school_name']??$_SESSION['full_names'];
$sql = "SELECT 
            COUNT(*) AS total_questions,
            COUNT(CASE WHEN ua.user_answer = q.correct_option THEN 1 END) AS correct_answers,
            COUNT(CASE WHEN ua.user_answer != q.correct_option AND ua.user_answer != 0 THEN 1 END) AS failed_answers,
            COUNT(CASE WHEN ua.user_answer IS NULL OR ua.user_answer = 0 THEN 1 END) AS null_answers,
            CEIL((COUNT(CASE WHEN ua.user_answer = q.correct_option THEN 1 END) / NULLIF(COUNT(*), 0)) * 100) AS score_percentage
        FROM user_answer ua
        JOIN questions q 
            ON ua.round_id = q.round_id 
            AND ua.question_number = q.question_number
        WHERE ua.user_id = '$user_id' 
        AND ua.round_id = '$round_id'";
$result = $conn->query($sql);
$row = $result->fetch_assoc();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exam Results for <?= $school_name.' ('. $user_id.' )'; ?></title>
    <style>
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }

        body {
            background: #f4f7f6;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        /* Container styles */
        .contain {
            width: 100%;
            max-width: 600px;
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        /* Header */
        h1 {
            font-size: 26px;
            color: #333;
            margin-bottom: 10px;
        }

        /* Score Section */
        h2 {
            font-size: 22px;
            color: #2b7a78;
            margin: 15px 0;
            font-weight: bold;
        }

        h3 {
            font-size: 18px;
            color: #555;
            margin-bottom: 10px;
        }

        p {
            font-size: 16px;
            color: #666;
            margin: 5px 0;
        }

        /* Retake Exam Button */
        footer {
            margin-top: 20px;
        }

        button {
            background: #2b7a78;
            color: white;
            border: none;
            padding: 12px 20px;
            font-size: 16px;
            border-radius: 6px;
            cursor: pointer;
            transition: 0.3s ease;
        }

        button:hover {
            background: #205e5a;
        }
        #score_percentage {
            font-size: 1.8rem;
            font-weight: bold;
        }
        .skipped_answers {
            font-weight: bolder;
            color: red;
        }

    </style>
</head>
<body>
    <div class="contain">
        <header>
            <h3>Exam Results For <?= $school_name.' ('. $user_id.' )'; ?></h3>
        </header>
        <main>
            <h2>Your Score: <span id="score_percentage"><?= $row['score_percentage'] ?></span>%</h2>
            <span id="user_id" hidden><?= $user_id; ?></span>
            <span id="round_id" hidden><?= $round_id; ?></span>
            <h3>Score Breakdown:</h3>
            <p><strong>Total Questions:</strong> <span id="total_questions"><?= $row['total_questions'] ?></span></p>
            <p><strong>Correct Answers:</strong> <span id="correct_answers"><?= $row['correct_answers'] ?></span></p>
            <p><strong>Failed Answers:</strong> <span id="failed_answers"><?= $row['failed_answers'] ?></span></p>
            <p class="skipped_answers"><strong>Skipped Answers:</strong> <span id="skipped_answers"><?= $row['null_answers'] ?></span></p>
        </main>
        <footer>
            <a href="logout.php" id="logout"><button>LogOut</button></a>
        </footer>
    </div>
    <script>
        
        // Wait for 5 seconds before sending data
        setTimeout(function() {
            let user_id = document.getElementById("user_id").innerText;
            let round_id = document.getElementById("round_id").innerText;
            let correct_answers = document.getElementById("correct_answers").innerText;
            let failed_answers = document.getElementById("failed_answers").innerText;
            let total_questions = document.getElementById("total_questions").innerText;
            let score_percentage = document.getElementById("score_percentage").innerText;
            let skipped_answers = document.getElementById("skipped_answers").innerText;

            let formData = new FormData();
            formData.append("user_id", user_id);
            formData.append("round_id", round_id);
            formData.append("correct_answers", correct_answers);
            formData.append("failed_answers", failed_answers);
            formData.append("total_questions", total_questions);
            formData.append("score_percentage", score_percentage);
            formData.append("skipped_answers", skipped_answers);

            fetch("requests/save_results.php", {
                method: "POST",
                body: formData
            })
            .then(response => response.text())
            .then(data => console.log(data))
            .catch(error => console.error("Error:", error));
        }, 2000); // 5 seconds delay
    </script>
</body>
</html>

<?php
$conn->close();
?>